/*****************************************************************************

	debug.c
	-------

	This module contains debug routines. It does not generate any code unless
	compiled with the identifier TEST defined.

	The file is written with a tab size of 4

	The N-Code system is Copyright (c) NPDSA 1992. The compiled programs may
	be used by anyone for any purpose, and may be distributed with or without
	the corresponding sources in any form providing that no fee	(other than a
	reasonable handling charge) is made.

	Development and enhancement work on the sources, and porting to machines
	not already supported, is welcomed. NPDSA will co-ordinate effort and will
	periodically release new versions that incorporate any new facilities. All
	source modules must contain this header information.

	NPDSA can be contacted by e-mail only on pdsoft@uk.ac.lancs.pdsoft (UK
	JANET network) and on pdsoft@pdsoft.lancs.ac.uk (Internet/BITNET). Please
	contact NPDSA before beginning a port to a new machine to see if anyone
	else is currently working in the same area.

	NPDSA accepts no liability whatsoever for any loss or damage incident on
	the use of any part of the N-Code system, and offers no warranty of any
	kind as the suitability of the N-Code system and its programs for any
	purpose.

*****************************************************************************/

/*******************************************************************************

	Local Procedures
	----------------

*******************************************************************************/

#ifdef	TEST

#include	"stdhead.h"

#ifdef	MSDOS
#include	<stdarg.h>
#endif

/* !Contents!
#ifdef TEST
#ifdef	PROTO
void	open_debug_file(char *);
void	debug(char *, ... );
#else
void	open_debug_file();
void	dprint();
#endif
#endif
*/


/*****************************************************************************

	Local Data
	----------

*****************************************************************************/

static	FILE	*debug_fp;				/* debug file pointer */

/*****************************************************************************

	open_debug_file
	---------------

	Opens a file for debugging output. The program exits if this fails

	open_debug_file(name);

	char	*name;				File name

*****************************************************************************/

#ifdef	PROTO
void	open_debug_file(char *name)
#else
void	open_debug_file(name)

char	*name;
#endif
{
	/* If the file name is '-', we debug to standard output */

	if ( strcmp(name,"-") == 0 )
	{
		printf("Debugging to standard output\n");
		debug_fp	= stdout;
		return;
	}

	/* Name isn't special, so debug to a file */
	
	if ( (debug_fp = fopen(name,"w")) != NULL )
		printf("Debugging to file %s\n",name);
	else
	{
		printf("Cannot open debug file %s\n",name);
		exit(1);
	}
}
	

#ifdef	MSDOS
/*****************************************************************************

	debug
	-----

	Writes a line to the debug file. The routine does nothing if debugging
	is not active.

	debug(format,args...)

	char	*format;				Output string format
	args...							Optional arguments

*****************************************************************************/

void	debug(char *format,...)

{
	va_list	arg_ptr;					/* arg list pointer */

	/* If debugging is not active, we do nothing */

	if ( debug_fp == NULL )
		return;

	/* Debugging is on. Build the message and output it */

	va_start(arg_ptr,format);
	vfprintf(debug_fp,format,arg_ptr);
	va_end(arg_ptr);

}
#endif

#ifdef	BSD42
/*****************************************************************************

	debug
	-----

	Writes a line to the debug file. The routine does nothing if debugging
	is not active.

	dprint(format,arg1,...,arg10)

	char	*format;				Output string format
	unsigned arg1...				Up to 10 optional arguments

*****************************************************************************/

void	dprint(format,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10)

char	*format;
unsigned	arg1;
unsigned	arg2;
unsigned	arg3;
unsigned	arg4;
unsigned	arg5;
unsigned	arg6;
unsigned	arg7;
unsigned	arg8;
unsigned	arg9;
unsigned	arg10;

{
	char	buffer[256];				/* buffer for message */

	/* If debugging is not active, we do nothing */

	if ( debug_fp == NULL )
		return;

	/* Debugging is on. Build the message and output it */

	sprintf(buffer,format,arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
	fprintf(debug_fp,buffer);
	fflush(debug_fp);

}
#endif


#endif

