/*	EBIND.H:	Standard key bindings for
			MicroEMACS 3.10 on VT100-type keyboard
$Header: ebind.h 1.6 92/03/09 $
$Log:	ebind.h,v $
 * Revision 1.6  92/03/09  11:07:49  phil
 * Changes for PTX
 * 
 * Revision 1.5  90/05/07  16:46:39  dan
 * Add ^BN and ^BP bindings
 * 
 * Revision 1.4  89/08/25  13:59:52  dan
 * Miscellaneous Mods to make compatable with GNU c
 * 
 * Revision 1.3  89/08/18  16:39:44  dan
 * Add Lancaster-style CTRL-B and CTRL-F prefix support, turned on via
 * the EXTRAKEYS option.
 * 
 * Revision 1.2  89/08/17  17:26:51  dan
 * Add support for GOLD prefix, if VTGOLD set
 * 
*/

/*
 * Command table.
 * This table  is *roughly* in ASCII order, left to right across the
 * characters of the command. This explains the funny location of the
 * control-X commands.
 */
NOSHARE KEYTAB	keytab[NBINDS] = {
	{CTRL|'A',		BINDFNC,	{gotobol}},
#if !EXTRAKEYS
	{CTRL|'B',		BINDFNC,	{backchar}},
#else
	{CTRL|'B',		BINDFNC,	{ctlb}},
#endif
	{CTRL|'C',		BINDFNC,	{insspace}},
	{CTRL|'D',		BINDFNC,	{forwdel}},
	{CTRL|'E',		BINDFNC,	{gotoeol}},
#if	!EXTRAKEYS
	{CTRL|'F',		BINDFNC,	{forwchar}},
#else
	{CTRL|'F',		BINDFNC,	{ctlf}},
#endif
	{CTRL|'G',		BINDFNC,	{ctrlg}},
	{CTRL|'H',		BINDFNC,	{backdel}},
	{CTRL|'I',		BINDFNC,	{tab}},
	{CTRL|'J',		BINDFNC,	{indent}},
	{CTRL|'K',		BINDFNC,	{killtext}},
	{CTRL|'L',		BINDFNC,	{refresh}},
	{CTRL|'M',		BINDFNC,	{newline}},
	{CTRL|'N',		BINDFNC,	{forwline}},
#if !EXTRAKEYS
	{CTRL|'O',		BINDFNC,	{openline}},
#else
	{CTRL|'O',		BINDFNC,	{forwchar}},
#endif
	{CTRL|'P',		BINDFNC,	{backline}},
#if	!LANCASTER
	{CTRL|'Q',		BINDFNC,	{quote}},
	{CTRL|'R',		BINDFNC,	{backsearch}},
	{CTRL|'S',		BINDFNC,	{forwsearch}},
#else
	{CTRL|'R',		BINDFNC,	{sreplace}},
#endif
#if !EXTRAKEYS
	{CTRL|'T',		BINDFNC,	{twiddle}},
#else
	{CTRL|'T',		BINDFNC,	{backchar}},
#endif
	{CTRL|'U',		BINDFNC,	{unarg}},
	{CTRL|'V',		BINDFNC,	{forwpage}},
	{CTRL|'W',		BINDFNC,	{killregion}},
	{CTRL|'X',		BINDFNC,	{cex}},
	{CTRL|'Y',		BINDFNC,	{yank}},
	{CTRL|'Z',		BINDFNC,	{backpage}},
	{CTRL|'[',		BINDFNC,	{meta}},
#if	EXTRAKEYS
	{CTLB|'B',		BINDFNC,	{backchar}},
	{CTLB|'F',		BINDFNC,	{forwchar}},
	{CTLB|'N',		BINDFNC,	{forwline}},
	{CTLB|'P',		BINDFNC,	{backline}},
	{CTLB|'S',		BINDFNC,	{newsize}},
	{CTLB|'Q',		BINDFNC,	{quote}},
	{CTLB|CTRL|'O',	BINDFNC,	{openline}},
	{CTLB|CTRL|'T',	BINDFNC,	{twiddle}},

	{CTLF|'I',		BINDFNC,	{insfile}},
	{CTLF|'F',		BINDFNC,	{filefind}},
	{CTLF|'N',		BINDFNC,	{filename}},
	{CTLF|'R',		BINDFNC,	{fileread}},
	{CTLF|'S',		BINDFNC,	{filesave}},
	{CTLF|'V',		BINDFNC,	{viewfile}},
	{CTLF|'W',		BINDFNC,	{filewrite}},
#endif
	{CTLX|CTRL|'B', 	BINDFNC,	{listbuffers}},
	{CTLX|CTRL|'C', 	BINDFNC,	{quit}},
#if	AEDIT
	{CTLX|CTRL|'D', 	BINDFNC,	{detab}},
	{CTLX|CTRL|'E', 	BINDFNC,	{entab}},
#endif
#if !EXTRAKEYS
	{CTLX|CTRL|'F', 	BINDFNC,	{filefind}},
	{CTLX|CTRL|'I', 	BINDFNC,	{insfile}},
#endif
	{CTLX|CTRL|'K',		BINDFNC,	{macrotokey}},
	{CTLX|CTRL|'L', 	BINDFNC,	{lowerregion}},
	{CTLX|CTRL|'M', 	BINDFNC,	{delmode}},
	{CTLX|CTRL|'N', 	BINDFNC,	{mvdnwind}},
	{CTLX|CTRL|'O', 	BINDFNC,	{deblank}},
	{CTLX|CTRL|'P', 	BINDFNC,	{mvupwind}},
#if !EXTRAKEYS
	{CTLX|CTRL|'R', 	BINDFNC,	{fileread}},
	{CTLX|CTRL|'S', 	BINDFNC,	{filesave}},
#endif
#if	AEDIT
	{CTLX|CTRL|'T', 	BINDFNC,	{trim}},
#endif
	{CTLX|CTRL|'U', 	BINDFNC,	{upperregion}},
#if !EXTRAKEYS
	{CTLX|CTRL|'V', 	BINDFNC,	{viewfile}},
	{CTLX|CTRL|'W', 	BINDFNC,	{filewrite}},
#endif
	{CTLX|CTRL|'X', 	BINDFNC,	{swapmark}},
	{CTLX|CTRL|'Z', 	BINDFNC,	{shrinkwind}},
	{CTLX|'?',		BINDFNC,	{deskey}},
	{CTLX|'!',		BINDFNC,	{spawn}},
	{CTLX|'@',		BINDFNC,	{pipecmd}},
	{CTLX|'#',		BINDFNC,	{filter}},
	{CTLX|'$',		BINDFNC,	{execprg}},
	{CTLX|'=',		BINDFNC,	{showcpos}},
	{CTLX|'(',		BINDFNC,	{ctlxlp}},
	{CTLX|')',		BINDFNC,	{ctlxrp}},
	{CTLX|'<',		BINDFNC,	{narrow}},
	{CTLX|'>',		BINDFNC,	{widen}},
	{CTLX|'^',		BINDFNC,	{enlargewind}},
	{CTLX|' ',		BINDFNC,	{remmark}},
	{CTLX|'0',		BINDFNC,	{delwind}},
	{CTLX|'1',		BINDFNC,	{onlywind}},
	{CTLX|'2',		BINDFNC,	{splitwind}},
	{CTLX|'A',		BINDFNC,	{setvar}},
	{CTLX|'B',		BINDFNC,	{usebuffer}},
	{CTLX|'C',		BINDFNC,	{spawncli}},
#if	BSD | USG
	{CTLX|'D',		BINDFNC,	{bktoshell}},
#endif
	{CTLX|'E',		BINDFNC,	{ctlxe}},
	{CTLX|'F',		BINDFNC,	{setfillcol}},
#if	DEBUGM
	{CTLX|'G',		BINDFNC,	{dispvar}},
#endif
	{CTLX|'K',		BINDFNC,	{killbuffer}},
	{CTLX|'M',		BINDFNC,	{setmod}},
#if !EXTRAKEYS
	{CTLX|'N',		BINDFNC,	{filename}},
#endif
	{CTLX|'O',		BINDFNC,	{nextwind}},
	{CTLX|'P',		BINDFNC,	{prevwind}},
#if	ISRCH
	{CTLX|'R',		BINDFNC,	{risearch}},
	{CTLX|'S',		BINDFNC,	{fisearch}},
#endif
	{CTLX|'W',		BINDFNC,	{resize}},
	{CTLX|'X',		BINDFNC,	{nextbuffer}},
	{CTLX|'Z',		BINDFNC,	{enlargewind}},
#if	WORDPRO
	{META|CTRL|'C', 	BINDFNC,	{wordcount}},
#endif
#if	PROC
	{META|CTRL|'E', 	BINDFNC,	{execproc}},
#endif
#if	CFENCE
	{META|CTRL|'F', 	BINDFNC,	{getfence}},
#endif
	{META|CTRL|'G', 	BINDFNC,	{gotomark}},
	{META|CTRL|'H', 	BINDFNC,	{delbword}},
	{META|CTRL|'K', 	BINDFNC,	{unbindkey}},
	{META|CTRL|'L', 	BINDFNC,	{reposition}},
	{META|CTRL|'M', 	BINDFNC,	{delgmode}},
	{META|CTRL|'N', 	BINDFNC,	{namebuffer}},
	{META|CTRL|'R', 	BINDFNC,	{qreplace}},
	{META|CTRL|'S', 	BINDFNC,	{execfile}},
	{META|CTRL|'V', 	BINDFNC,	{nextdown}},
#if	WORDPRO
	{META|CTRL|'W', 	BINDFNC,	{killpara}},
#endif
	{META|CTRL|'X', 	BINDFNC,	{execcmd}},
	{META|CTRL|'Z', 	BINDFNC,	{nextup}},
	{META|' ',		BINDFNC,	{setmark}},
	{META|'?',		BINDFNC,	{help}},
	{META|'!',		BINDFNC,	{reposition}},
	{META|'.',		BINDFNC,	{setmark}},
	{META|'>',		BINDFNC,	{gotoeob}},
	{META|'<',		BINDFNC,	{gotobob}},
	{META|'~',		BINDFNC,	{unmark}},
#if	APROP
	{META|'A',		BINDFNC,	{apro}},
#endif
	{META|'B',		BINDFNC,	{backword}},
	{META|'C',		BINDFNC,	{capword}},
	{META|'D',		BINDFNC,	{delfword}},
#if	CRYPT
	{META|'E',		BINDFNC,	{setekey}},
#endif
	{META|'F',		BINDFNC,	{forwword}},
	{META|'G',		BINDFNC,	{gotoline}},
	{META|'K',		BINDFNC,	{bindtokey}},
	{META|'L',		BINDFNC,	{lowerword}},
	{META|'M',		BINDFNC,	{setgmode}},
#if	WORDPRO
	{META|'N',		BINDFNC,	{gotoeop}},
	{META|'P',		BINDFNC,	{gotobop}},
	{META|'Q',		BINDFNC,	{fillpara}},
#endif
#if !LANCASTER
	{META|'R',		BINDFNC,	{sreplace}},
#if	BSD | USG
	{META|'S',		BINDFNC,	{bktoshell}},
#endif
#else
	{META|'R',		BINDFNC,	{backsearch}},
	{META|'S',		BINDFNC,	{forwsearch}},
#endif
	{META|'U',		BINDFNC,	{upperword}},
	{META|'V',		BINDFNC,	{backpage}},
	{META|'W',		BINDFNC,	{copyregion}},
	{META|'X',		BINDFNC,	{namedcmd}},
	{META|'Z',		BINDFNC,	{quickexit}},
	{META|0x7F,		BINDFNC,	{delbword}},

#if	MOUSE
	{MOUS|'a',		BINDFNC,	{movemd}},
	{MOUS|'b',		BINDFNC,	{movemu}},
	{MOUS|'e',		BINDFNC,	{mregdown}},
	{MOUS|'f',		BINDFNC,	{mregup}},
	{MOUS|'1',		BINDFNC,	{resizm}},
#endif 

	{ALTD|'S',		BINDFNC,	{forwhunt}},
	{ALTD|'R',		BINDFNC,	{backhunt}},
	{SPEC|'<',		BINDFNC,	{gotobol}},
	{SPEC|'P',		BINDFNC,	{backline}},
	{SPEC|'Z',		BINDFNC,	{backpage}},
	{SPEC|'B',		BINDFNC,	{backchar}},
	{SPEC|'F',		BINDFNC,	{forwchar}},
	{SPEC|'>',		BINDFNC,	{gotoeol}},
	{SPEC|'N',		BINDFNC,	{forwline}},
	{SPEC|'V',		BINDFNC,	{forwpage}},
	{SPEC|'C',		BINDFNC,	{insspace}},
	{SPEC|'D',		BINDFNC,	{forwdel}},
	{SPEC|CTRL|'<',		BINDFNC,	{gotobob}},
	{SPEC|CTRL|'B', 	BINDFNC,	{backword}},
	{SPEC|CTRL|'F', 	BINDFNC,	{forwword}},
	{SPEC|CTRL|'>',		BINDFNC,	{gotoeob}},
#if	WORDPRO
	{SPEC|CTRL|'Z', 	BINDFNC,	{gotobop}},
	{SPEC|CTRL|'V', 	BINDFNC,	{gotoeop}},
#endif
	{SPEC|SHFT|'1', 	BINDFNC,	{cbuf1}},
	{SPEC|SHFT|'2', 	BINDFNC,	{cbuf2}},
	{SPEC|SHFT|'3', 	BINDFNC,	{cbuf3}},
	{SPEC|SHFT|'4', 	BINDFNC,	{cbuf4}},
	{SPEC|SHFT|'5', 	BINDFNC,	{cbuf5}},
	{SPEC|SHFT|'6', 	BINDFNC,	{cbuf6}},
	{SPEC|SHFT|'7', 	BINDFNC,	{cbuf7}},
	{SPEC|SHFT|'8', 	BINDFNC,	{cbuf8}},
	{SPEC|SHFT|'9', 	BINDFNC,	{cbuf9}},
	{SPEC|SHFT|'0', 	BINDFNC,	{cbuf10}},
#if	VTGOLD
	{SPEC|'a',		BINDFNC,	{gold}},
#endif
 
	{0x7F,			BINDFNC,	{backdel}},

	{0,			BINDNUL,	{NULL}}
};
