/*	EVAR.H: Environment and user variable definitions
		for MicroEMACS

		written 1986 by Daniel Lawrence
*/

/*	structure to hold user variables and their definitions	*/

typedef struct UVAR {
	char u_name[NVSIZE + 1];	       /* name of user variable */
	char *u_value;				/* value (string) */
} UVAR;

/*	current user variables (This structure will probably change)	*/

#define MAXVARS 	512

UVAR NOSHARE uv[MAXVARS + 1];	/* user variables */

#if !LANCASTER

/*	list of recognized environment variables	*/

NOSHARE char *envars[] = {
	"acount",		/* # of chars until next auto-save */
	"asave",		/* # of chars between auto-saves */
	"bufhook",		/* enter buffer switch hook */
	"cbflags",		/* current buffer flags */
	"cbufname",		/* current buffer name */
	"cfname",		/* current file name */
	"cmdhook",		/* command loop hook */
	"cmode",		/* mode of current buffer */
	"curchar",		/* current character under the cursor */
	"curcol",		/* current column pos of cursor */
	"curline",		/* current line in file */
	"curwidth",		/* current screen width */
	"cwline",		/* current screen line in window */
	"debug",		/* macro debugging */
	"diagflag",		/* diagonal mouse movements enabled? */
	"discmd",		/* display commands on command line */
	"disinp",		/* display command line input characters */
	"exbhook",		/* exit buffer switch hook */
	"fcol",			/* first displayed column in curent window */
	"fillcol",		/* current fill column */
	"flicker",		/* flicker supression */
	"gflags",		/* global internal emacs flags */
	"gmode",		/* global modes */
	"hardtab",		/* current hard tab size */
	"hjump",		/* horizontal screen jump size */
	"hscroll",		/* horizontal scrolling flag */
	"kill", 		/* kill buffer (read only) */
	"language",		/* language of text messages */
	"lastkey",		/* last keyboard char struck */
	"lastmesg",		/* last string mlwrite()ed */
	"line", 		/* text of current line */
	"lwidth",		/* width of current line */
	"match",		/* last matched magic pattern */
	"modeflag",		/* Modelines displayed flag */
	"msflag",		/* activate mouse? */
	"oldcrypt",		/* use old(broken) encryption */
	"pagelen",		/* number of lines used by editor */
	"palette",		/* current palette string */
	"pending",		/* type ahead pending flag */
	"progname",		/* returns current prog name - "MicroEMACS" */
	"ram",			/* ram in use by malloc */
	"readhook",		/* read file execution hook */
	"region",		/* current region (read only) */
	"replace",		/* replacement pattern */
	"rval", 		/* child process return value */
	"search",		/* search pattern */
	"seed", 		/* current random number seed */
	"softtab",		/* current soft tab size */
	"sres", 		/* current screen resolution */
	"ssave",		/* safe save flag */
	"sscroll",		/* smooth scrolling flag */
	"status",		/* returns the status of the last command */
	"sterm",		/* search terminator character */
	"target",		/* target for line moves */
	"time",			/* date and time */
	"tpause",		/* length to pause for paren matching */
	"version",		/* current version number */
	"wline",		/* # of lines in current window */
	"wraphook",		/* wrap word execution hook */
	"writehook",		/* write file hook */
	"xpos", 		/* current mouse X position */
	"ypos"	 		/* current mouse Y position */
};

#define NEVARS	sizeof(envars) / sizeof(char *)
#endif

/*	and its preprocesor definitions 	*/

#define EVACOUNT	0
#define EVASAVE 	1
#define	EVBUFHOOK	2
#define EVCBFLAGS	3
#define EVCBUFNAME	4
#define EVCFNAME	5
#define EVCMDHK 	6
#define EVCMODE 	7
#define EVCURCHAR	8
#define EVCURCOL	9
#define EVCURLINE	10
#define EVCURWIDTH	11
#define EVCWLINE	12
#define EVDEBUG         13
#define EVDIAGFLAG      14
#define EVDISCMD        15
#define EVDISINP        16
#define EVEXBHOOK       17
#define EVFCOL		18
#define EVFILLCOL	19
#define EVFLICKER	20
#define EVGFLAGS	21
#define EVGMODE 	22
#define	EVHARDTAB	23
#define EVHJUMP		24
#define EVHSCROLL	25
#define EVKILL          26
#define EVLANG          27
#define EVLASTKEY       28
#define EVLASTMESG      29
#define EVLINE          30
#define EVLWIDTH        31
#define EVMATCH         32
#define EVMODEFLAG      33
#define EVMSFLAG        34
#define	EVOCRYPT	35
#define EVPAGELEN       36
#define EVPALETTE       37
#define EVPENDING       38
#define EVPROGNAME      39
#define EVRAM           40
#define EVREADHK        41
#define	EVREGION	42
#define EVREPLACE       43
#define EVRVAL          44
#define EVSEARCH        45
#define EVSEED          46
#define EVSOFTTAB	47
#define EVSRES          48
#define EVSSAVE         49
#define EVSSCROLL	50
#define EVSTATUS	51
#define EVSTERM 	52
#define EVTARGET	53
#define EVTIME		54
#define EVTPAUSE	55
#define EVVERSION	56
#define EVWLINE 	57
#define EVWRAPHK	58
#define	EVWRITEHK	59
#define EVXPOS		60
#define EVYPOS		61

#if LANCASTER
#define EVBACKUP	62
#define EVBREAKIN	63
#define EVMACLOOP	64
#define EVTCFLAGS	65
#endif

#if LANCASTER

/*	list of recognized environment variables	*/

typedef struct ENVAR {
	char * ev_name;		/* Pointer to name */
	int ev_number;		/* Number for switching */
} ENVAR;

NOSHARE ENVAR envars[] = {
	"acount", 	EVACOUNT,		/* # of chars until next auto-save */
	"asave",	EVASAVE,		/* # of chars between auto-saves */
	"backup",	EVBACKUP,		/* Auto backup switch */
	"breakin",	EVBREAKIN,		/* Macro breakins enabled */
	"bufhook",	EVBUFHOOK,		/* enter buffer switch hook */
	"cbflags",	EVCBFLAGS,		/* current buffer flags */
	"cbufname",	EVCBUFNAME,		/* current buffer name */
	"cfname",	EVCFNAME,		/* current file name */
	"cmdhook",	EVCMDHK,		/* command loop hook */
	"cmode",	EVCMODE,		/* mode of current buffer */
	"curchar",	EVCURCHAR,		/* current character under the cursor */
	"curcol",	EVCURCOL,		/* current column pos of cursor */
	"curline",	EVCURLINE,		/* current line in file */
	"curwidth",	EVCURWIDTH,		/* current screen width */
	"cwline",	EVCWLINE,		/* current screen line in window */
	"debug",	EVDEBUG,		/* macro debugging */
	"diagflag",	EVDIAGFLAG,		/* diagonal mouse movements enabled? */
	"discmd",	EVDISCMD,		/* display commands on command line */
	"disinp",	EVDISINP,		/* display command line input characters */
	"exbhook",	EVEXBHOOK,		/* exit buffer switch hook */
	"fcol",		EVFCOL,			/* first displayed column in curent window */
	"fillcol",	EVFILLCOL,		/* current fill column */
	"flicker",	EVFLICKER,		/* flicker supression */
	"gflags",	EVGFLAGS,		/* global internal emacs flags */
	"gmode",	EVGMODE,		/* global modes */
	"hardtab",	EVHARDTAB,		/* current hard tab size */
	"hjump",	EVHJUMP,		/* horizontal screen jump size */
	"hscroll",	EVHSCROLL,		/* horizontal scrolling flag */
	"kill",		EVKILL, 		/* kill buffer (read only) */
	"language",	EVLANG,			/* language of text messages */
	"lastkey",	EVLASTKEY,		/* last keyboard char struck */
	"lastmesg",	EVLASTMESG,		/* last string mlwrite()ed */
	"line",		EVLINE, 		/* text of current line */
	"lwidth",	EVLWIDTH,		/* width of current line */
	"macloop",	EVMACLOOP,		/* Max number of loops within macro */
	"match",	EVMATCH,		/* last matched magic pattern */
	"modeflag",	EVMODEFLAG,		/* Modelines displayed flag */
	"msflag",	EVMSFLAG,		/* activate mouse? */
	"oldcrypt",	EVOCRYPT,		/* use old(broken) encryption */
	"pagelen",	EVPAGELEN,		/* number of lines used by editor */
	"palette",	EVPALETTE,		/* current palette string */
	"pending",	EVPENDING,		/* type ahead pending flag */
	"progname",	EVPROGNAME,		/* returns current prog name - "MicroEMACS" */
	"ram",		EVRAM,			/* ram in use by malloc */
	"readhook",	EVREADHK,		/* read file execution hook */
	"region",	EVREGION,		/* current region (read only) */
	"replace",	EVREPLACE,		/* replacement pattern */
	"rval",		EVRVAL, 		/* child process return value */
	"search",	EVSEARCH,		/* search pattern */
	"seed",		EVSEED, 		/* current random number seed */
	"softtab",	EVSOFTTAB,		/* current soft tab size */
	"sres",		EVSRES, 		/* current screen resolution */
	"ssave",	EVSSAVE,		/* safe save flag */
	"sscroll",	EVSSCROLL,		/* smooth scrolling flag */
	"status",	EVSTATUS,		/* returns the status of the last command */
	"sterm",	EVSTERM,		/* search terminator character */
	"target",	EVTARGET,		/* target for line moves */
#if TERMCAP
	"tcflags",	EVTCFLAGS,		/* Terminal capability flags */
#endif
	"time",		EVTIME,			/* date and time */
	"tpause",	EVTPAUSE,		/* length to pause for paren matching */
	"version",	EVVERSION,		/* current version number */
	"wline",	EVWLINE,		/* # of lines in current window */
	"wraphook",	EVWRAPHK,		/* wrap word execution hook */
	"writehook",	EVWRITEHK,		/* write file hook */
	"xpos",		EVXPOS, 		/* current mouse X position */
	"ypos",		EVYPOS	 		/* current mouse Y position */
};

#define NEVARS	sizeof(envars) / sizeof(ENVAR)
#endif

/*	list of recognized user functions	*/

typedef struct UFUNC {
	char *f_name;	/* name of function */
	int f_type;		/* 1 = monamic, 2 = dynamic */
#if	LANCASTER
	int	f_number;	/* function number for switchery */
#endif
} UFUNC;

#define NILNAMIC	0
#define MONAMIC 	1
#define DYNAMIC 	2
#define TRINAMIC	3

/*	Table of function numbers used in switches */

#define UFABS		0
#define UFADD		1
#define UFAND		2
#define UFASCII 	3
#define UFBAND		4
#define UFBIND		5
#define UFBNOT		6
#define UFBOR		7
#define UFBXOR		8
#define UFCAT		9
#define UFCHR		10
#define UFDIV		11
#define UFENV		12
#define UFEQUAL 	13
#define UFEXIST 	14
#define UFFIND		15
#define UFGREATER	16
#define UFGTCMD 	17
#define UFGTKEY 	18
#define UFIND		19
#define UFLEFT		20
#define UFLENGTH	21
#define UFLESS		22
#define UFLOWER 	23
#define UFMID		24
#define UFMOD		25
#define UFNEG		26
#define UFNOT		27
#define UFOR		28
#define UFRIGHT 	29
#define UFRND		30
#define UFSEQUAL	31
#define UFSGREAT	32
#define UFSINDEX	33
#define UFSLESS 	34
#define	UFSLOWER	35
#define UFSUB		36
#define	UFSUPPER	37
#define UFTIMES 	38
#define	UFTRIM		39
#define UFTRUTH 	40
#define UFUPPER 	41
#define UFXLATE 	42
#if	LANCASTER
#define	UFSRINDEX	43
#endif

#if	LANCASTER == 0
NOSHARE UFUNC funcs[] = {
	"abs", MONAMIC, 	/* absolute value of a number */
	"add", DYNAMIC,		/* add two numbers together */
	"and", DYNAMIC, 	/* logical and */
	"asc", MONAMIC, 	/* char to integer conversion */
	"ban", DYNAMIC, 	/* bitwise and	 9-10-87  jwm */
	"bin", MONAMIC, 	/* loopup what function name is bound to a key */
	"bno", MONAMIC, 	/* bitwise not */
	"bor", DYNAMIC, 	/* bitwise or	 9-10-87  jwm */
	"bxo", DYNAMIC, 	/* bitwise xor	 9-10-87  jwm */
	"cat", DYNAMIC, 	/* concatinate string */
	"chr", MONAMIC, 	/* integer to char conversion */
	"div", DYNAMIC, 	/* division */
	"env", MONAMIC, 	/* retrieve a system environment var */
	"equ", DYNAMIC, 	/* logical equality check */
	"exi", MONAMIC, 	/* check if a file exists */
	"fin", MONAMIC, 	/* look for a file on the path... */
	"gre", DYNAMIC, 	/* logical greater than */
	"gtc", NILNAMIC,	/* get 1 emacs command */
	"gtk", NILNAMIC,	/* get 1 charater */
	"ind", MONAMIC, 	/* evaluate indirect value */
	"lef", DYNAMIC, 	/* left string(string, len) */
	"len", MONAMIC, 	/* string length */
	"les", DYNAMIC, 	/* logical less than */
	"low", MONAMIC, 	/* lower case string */
	"mid", TRINAMIC,	/* mid string(string, pos, len) */
	"mod", DYNAMIC, 	/* mod */
	"neg", MONAMIC, 	/* negate */
	"not", MONAMIC, 	/* logical not */
	"or",  DYNAMIC, 	/* logical or */
	"rig", DYNAMIC, 	/* right string(string, pos) */
	"rnd", MONAMIC, 	/* get a random number */
	"seq", DYNAMIC, 	/* string logical equality check */
	"sgr", DYNAMIC, 	/* string logical greater than */
	"sin", DYNAMIC, 	/* find the index of one string in another */
	"sle", DYNAMIC, 	/* string logical less than */
	"slo", DYNAMIC,		/* set lower to upper char translation */
	"sub", DYNAMIC, 	/* subtraction */
	"sup", DYNAMIC,		/* set upper to lower char translation */
	"tim", DYNAMIC, 	/* multiplication */
	"tri", MONAMIC,		/* trim whitespace off the end of a string */
	"tru", MONAMIC, 	/* Truth of the universe logical test */
	"upp", MONAMIC, 	/* uppercase string */
	"xla", TRINAMIC		/* XLATE character string translation */
};
#else
NOSHARE UFUNC funcs[] = {
	"abs", MONAMIC, UFABS,		/* absolute value of a number */
	"add", DYNAMIC, UFADD,		/* add two numbers together */
	"and", DYNAMIC, UFAND,		/* logical and */
	"asc", MONAMIC, UFASCII,	/* char to integer conversion */
	"ban", DYNAMIC, UFBAND,		/* bitwise and	 9-10-87  jwm */
	"bin", MONAMIC, UFBIND,		/* loopup what function name is bound to a key */
	"bno", MONAMIC, UFBNOT,		/* bitwise not */
	"bor", DYNAMIC, UFBOR,		/* bitwise or	 9-10-87  jwm */
	"bxo", DYNAMIC, UFBXOR,		/* bitwise xor	 9-10-87  jwm */
	"cat", DYNAMIC, UFCAT,		/* concatinate string */
	"chr", MONAMIC, UFCHR,		/* integer to char conversion */
	"div", DYNAMIC, UFDIV,		/* division */
	"env", MONAMIC, UFENV,		/* retrieve a system environment var */
	"equ", DYNAMIC, UFEQUAL,	/* logical equality check */
	"exi", MONAMIC, UFEXIST,	/* check if a file exists */
	"fin", MONAMIC, UFFIND,		/* look for a file on the path... */
	"gre", DYNAMIC, UFGREATER,	/* logical greater than */
	"gtc", NILNAMIC, UFGTCMD,	/* get 1 emacs command */
	"gtk", NILNAMIC, UFGTKEY,	/* get 1 charater */
	"ind", MONAMIC, UFIND,		/* evaluate indirect value */
	"lef", DYNAMIC, UFLEFT,		/* left string(string, len) */
	"len", MONAMIC, UFLENGTH,	/* string length */
	"les", DYNAMIC, UFLESS,		/* logical less than */
	"low", MONAMIC, UFLOWER,	/* lower case string */
	"mid", TRINAMIC, UFMID,		/* mid string(string, pos, len) */
	"mod", DYNAMIC, UFMOD,		/* mod */
	"neg", MONAMIC, UFNEG,		/* negate */
	"not", MONAMIC, UFNOT,		/* logical not */
	"or",  DYNAMIC, UFOR,		/* logical or */
	"rig", DYNAMIC, UFRIGHT,	/* right string(string, pos) */
	"rnd", MONAMIC, UFRND,		/* get a random number */
	"seq", DYNAMIC, UFSEQUAL,	/* string logical equality check */
	"sgr", DYNAMIC, UFSGREAT,	/* string logical greater than */
	"sin", DYNAMIC, UFSINDEX,	/* find the index of one string in another */
	"sle", DYNAMIC, UFSLESS,	/* string logical less than */
	"slo", DYNAMIC, UFSLOWER,	/* set lower to upper char translation */
#if	LANCASTER
	"sri", DYNAMIC, UFSRINDEX,	/* reverse index of one string in another */
#endif
	"sub", DYNAMIC, UFSUB,		/* subtraction */
	"sup", DYNAMIC, UFUPPER,	/* set upper to lower char translation */
	"tim", DYNAMIC, UFTIMES,	/* multiplication */
	"tri", MONAMIC, UFTRIM,		/* trim whitespace off the end of a string */
	"tru", MONAMIC, UFTRUTH,	/* Truth of the universe logical test */
	"upp", MONAMIC, UFUPPER,	/* uppercase string */
	"xla", TRINAMIC, UFXLATE	/* XLATE character string translation */
};
#endif

#define NFUNCS	sizeof(funcs) / sizeof(UFUNC)

