/*	tcap:	Unix V5, SUN OS, SCO XENIX, V7 and BS4.2 Termcap video driver
		for MicroEMACS 3.10

		 1989 	  - Lancaster mods - Daniel Pead
		 			The VT100/200 terminals are treated as a special case,
		 			in that the VT keypad and hardware scrolling are
		 			hard-coded into this file and activated by the flag
		 			"VT" in the termcap file.  The VT keypad is treated
		 			as a seperate entity to any function keys.
		
         12-10-88 - Modifications made by Guy Turcotte to accomodate
                    SunOS V4.0 and Xenix V2.2.1 :
 
                  SunOS mods:
                  
                  o p_seq field of TBIND struct augmented to 10 chars
                    to take into account longer definitions for keys
                    (some Sun's keys definitions need at least 7 chars...)
                    as such, the code in get1key has been modified to take
                    care of the longer p_seq string.
 
                  o tcapopen modified to take care of the tgetstr problem
                    (returns NULL on undefined keys instead of a valid
                    string pointer...)
 
                  o The timout algorithm of get1key has been modified to
                    take care of the following select() function problem:
                    if some chars are already in the terminal buffer before
                    select is called and no others char appears on the terminal,
                    it will timeout anyway... (maybe a feature of SunOs V4.0)
 
                  Xenix mods:
 
                  o The first two points indicated above are applicable for
                    the Xenix OS
 
                  o With my current knowledge, I can't find a clean solution
                    to the timeout problem of the get1key function
                    under Xenix. I modified the code to get rid of the BSD code 
                    (via the #if directive) and use the Xenix nap() and rdchk()
                    functions to 
                    make a 1/30 second wait. Seems to work as long as there is
                    not to much of activity from other processes on the system.
                    (The link command of the makefile must be modified to
                    link with the x library... you must add the option -lx)
 
                  o The input.c file has been modified to not include the
                    get1key function defined there in the case of USG. The
                    #if directive preceeding the get1key definition has been
                    modified from:
 
                     #if (V7 == 0) && (BSD == 0)
 
                    to:
 
                     #if (V7 == 0) && (BSD == 0) && (USG == 0)
                     
                  o The following lines define the new termcap entry for
                    the ansi kind of terminal: it permits the use of functions
                    keys F1 .. F10 and keys HOME,END,PgUp,PgDn on the IBM PC
                    keyboard (the last 3 lines of the definition have been
                    added):
$Header: /uol/system/UEMACSv3.10/source/RCS/tcap.c,v 1.14 93/03/12 17:04:24 phil Exp $
$Log:	tcap.c,v $
 * Revision 1.14  93/03/12  17:04:24  phil
 * Change get1key to handle null characters and stop looping
 * 
 * Revision 1.13  92/03/09  11:05:22  phil
 * Changes for PTX
 * 
 * Revision 1.12  90/05/11  17:46:53  dan
 * More function key name mods, and a change to tgetc - don't fold
 * CTRL bit back into character if base character is < 65 !
 * 
 * Revision 1.11  90/05/11  10:46:23  dan
 * Change function key naming scheme...
 * 
 * Revision 1.10  90/03/29  13:50:26  dan
 * Remove a couple of ANSI-isms
 * 
 * Revision 1.9  90/03/16  16:13:41  dan
 * Modify VT capability to accept a series of flags for VT100/200 and scroll
 * capabilities.
 * 
 * Revision 1.8  89/11/06  14:34:18  dan
 * Add hard-scroll function into term structure
 * 
 * Revision 1.7  89/11/03  17:10:09  dan
 * Add hardware-based smooth scrolling.  Major revisions to reframe() in
 * display.c
 * 
 * Revision 1.6  89/08/29  15:38:50  dan
 * Add expansion of leading ~ in file names
 * 
 * Revision 1.5  89/08/25  12:12:03  dan
 * Add special-case support for VT100 keypad,
 * Add VT220-style editing keys FIND, SELECT, INS HERE and REMOVE
 * Exclude function keys unsupported by current terminal from search
 * during GET1KEY
 * 
 * Revision 1.4  89/08/23  13:24:24  dan
 * Rewrite GET1KEY routine - the method of waiting 1/30 sec after an ESC
 * to see if it is a keyboard generated escape sequence rather than the
 * ESC key does not work reliably over a network.  Instead, buffer the
 * string following ESC and compare it against the possible function
 * keys.
 * 
 * Revision 1.3  89/08/18  16:41:17  dan
 * Add Lancaster-style CTRL-B and CTRL-F prefix support, turned on via
 * the EXTRAKEYS option.
 * 
 * Revision 1.2  89/08/17  17:27:58  dan
 * Add support for GOLD prefix, if VTGOLD set
 * 
 
 li|ansi|Ansi standard crt:\
 	:al=\E[L:am:bs:cd=\E[J:ce=\E[K:cl=\E[2J\E[H:cm=\E[%i%d;%dH:co#80:\
 	:dc=\E[P:dl=\E[M:do=\E[B:bt=\E[Z:ei=:ho=\E[H:ic=\E[@:im=:li#25:\
 	:nd=\E[C:pt:so=\E[7m:se=\E[m:us=\E[4m:ue=\E[m:up=\E[A:\
 	:kb=^h:ku=\E[A:kd=\E[B:kl=\E[D:kr=\E[C:eo:sf=\E[S:sr=\E[T:\
 	:GS=\E[12m:GE=\E[10m:GV=\63:GH=D:\
 	:GC=E:GL=\64:GR=C:RT=^J:G1=?:G2=Z:G3=@:G4=Y:GU=A:GD=B:\
 	:CW=\E[M:NU=\E[N:RF=\E[O:RC=\E[P:\
 	:WL=\E[S:WR=\E[T:CL=\E[U:CR=\E[V:\
 	:HM=\E[H:EN=\E[F:PU=\E[I:PD=\E[G:\
 	:k1=\E[M:k2=\E[N:k3=\E[O:k4=\E[P:k5=\E[Q:\
 	:k6=\E[R:k7=\E[S:k8=\E[T:k9=\E[U:k0=\E[V:\
 	:kh=\E[H:kH=\E[F:kA=\E[L:kN=\E[G:kP=\E[I:
                    
*/

#define termdef 1			/* don't define "term" external */

#include <stdio.h>
#include	"estruct.h"
#include	"etype.h"
#include	"edef.h"
#include	"elang.h"

#if TERMCAP

#if	USG | HPUX
#include	<time.h>
#endif
#if	BSD | V7
#include	<sys/types.h>
#include	<sys/time.h>
#endif

#define MARGIN	8
#define SCRSIZ	64
#define NPAUSE	10			/* # times thru update to pause */
#define BEL	0x07
#define ESC	0x1B
#if LANCASTER
#define MAXESC 10
#if USG
#define VTCAP "pa"
#define F10 "k;"
#define F11 "F1"
#define F12 "F2"
#define F13 "F3"
#define F14 "F4"
#define F15 "F5"
#define F16 "F6"
#define F17 "F7"
#define F18 "F8"
#define F19 "F9"
#define F20 "FA"
#define F21 "FB"
#define F22 "FC"
#define F23 "FD"
#define F24 "FE"
#define F25 "FF"
#define F26 "FG"
#define F27 "FH"
#define F28 "FI"
#define F29 "FJ"
#define F30 "FK"
#define F31 "FL"
#define F32 "FM"
#define F33 "FN"
#define F34 "FO"
#define F35 "FP"
#define F36 "FQ"
#define F37 "FR"
#define F38 "FS"
#define F39 "FT"
#define F40 "FU"
#define F41 "FV"
#define F42 "FW"
#define F43 "FX"
#define F44 "FY"
#define F45 "FZ"
#define F46 "Fa"
#define F47 "Fb"
#define F48 "Fc"
#define F49 "Fd"
#define F50 "Fe"
#else
#define VTCAP "VT"
#define F10 "k0"
#define F11 "Ka"
#define F12 "Kb"
#define F13 "Kc"
#define F14 "Kd"
#define F15 "Ke"
#define F16 "Kf"
#define F17 "Kg"
#define F18 "Kh"
#define F19 "Ki"
#define F20 "Kj"
#define F21 "K1"
#define F22 "K2"
#define F23 "K3"
#define F24 "K4"
#define F25 "K5"
#define F26 "K6"
#define F27 "K7"
#define F28 "K8"
#define F29 "K9"
#define F30 "K0"
#define F31 "KA"
#define F32 "KB"
#define F33 "KC"
#define F34 "KD"
#define F35 "KE"
#define F36 "KF"
#define F37 "KG"
#define F38 "KH"
#define F39 "KI"
#define F40 "KJ"
#define F41 "Kt"
#define F42 "kh"
#define F43 "kD"
#define F44 "kV"
#define F45 "kZ"
#define F46 "kI"
#define F47 "kT"
#define F48 "kH"
#define F49 "kN"
#define F50 "kP"
#endif

/* Flags in tcflags */

#define		TCF_NFMASK	0x1f	/* Mask for function key count */
#define		TCF_HSCRL	0x20	/* VT100 Hard scroll available */
#define		TCF_VTKEYS	0x40	/* VT100/200 keypad available  */
#define		TCF_VT200	0x80	/* VT200/300 cluster available */
#endif


/*	Termcap Sequence definitions	*/

typedef struct TBIND {
	char p_name[4]; /* sequence name */
	int  p_code;	/* resulting keycode of sequence */
	char p_seq[10];	/* terminal escape sequence */
} TBIND;

/* Standard MicroEMACS V3.10 key names */

static TBIND ttable[] = {
	"bt",	SHFT | CTRL | 'i',	"",	/* backtab */
	"k1",	SPEC | '1',		"",	/* function key 1 */
	"k2",	SPEC | '2',		"",	/* function key 2 */
	"k3",	SPEC | '3',		"",	/* function key 3 */
	"k4",	SPEC | '4',		"",	/* function key 4 */
	"k5",	SPEC | '5',		"",	/* function key 5 */
	"k6",	SPEC | '6',		"",	/* function key 6 */
	"k7",	SPEC | '7',		"",	/* function key 7 */
	"k8",	SPEC | '8',		"",	/* function key 8 */
	"k9",	SPEC | '9',		"",	/* function key 9 */
	F10,	SPEC | '0',		"",	/* function key 10/0 */
#if LANCASTER

	/* The following introduces many non-standard termcap fields.  			*/
	/* The new ones have at least 1 upper case letter in each to help  		*/
	/* distinguish from the standard ones.  								*/

	/* XENIX defines several new termcap entries, but those don't make  	*/
	/* sense unless you're running multiplan, so I've ignored them.			*/
	
	/* More function keys... */

	F11,	SPEC | 'a',		"",	/* function key 11 */
	F12,	SPEC | 'b',		"",	/* function key 12 */
	F13,	SPEC | 'c',		"",	/* function key 13 */
	F14,	SPEC | 'd',		"",	/* function key 14 */
	F15,	SPEC | 'e',		"",	/* function key 15 */
	F16,	SPEC | 'f',		"",	/* function key 16 */
	F17,	SPEC | 'g',		"",	/* function key 17 */
	F18,	SPEC | 'h',		"",	/* function key 18 */
	F19,	SPEC | 'i',		"",	/* function key 19 */
	F20,	SPEC | 'j',		"",	/* function key 20 */
	F21,	SHFT | SPEC | '1',		"",	/* SHIFT-function key 1 */
	F22,	SHFT | SPEC | '2',		"",	/* SHIFT-function key 2 */
	F23,	SHFT | SPEC | '3',		"",	/* SHIFT-function key 3 */
	F24,	SHFT | SPEC | '4',		"",	/* SHIFT-function key 4 */
	F25,	SHFT | SPEC | '5',		"",	/* SHIFT-function key 5 */
	F26,	SHFT | SPEC | '6',		"",	/* SHIFT-function key 6 */
	F27,	SHFT | SPEC | '7',		"",	/* SHIFT-function key 7 */
	F28,	SHFT | SPEC | '8',		"",	/* SHIFT-function key 8 */
	F29,	SHFT | SPEC | '9',		"",	/* SHIFT-function key 9 */
	F30,	SHFT | SPEC | '0',		"",	/* SHIFT-function key 10/0 */
	F31,	SHFT | SPEC | 'a',		"",	/* SHIFT-function key 11 */
	F32,	SHFT | SPEC | 'b',		"",	/* SHIFT-function key 12 */
	F33,	SHFT | SPEC | 'c',		"",	/* SHIFT-function key 13 */
	F34,	SHFT | SPEC | 'd',		"",	/* SHIFT-function key 14 */
	F35,	SHFT | SPEC | 'e',		"",	/* SHIFT-function key 15 */
	F36,	SHFT | SPEC | 'f',		"",	/* SHIFT-function key 16 */
	F37,	SHFT | SPEC | 'g',		"",	/* SHIFT-function key 17 */
	F38,	SHFT | SPEC | 'h',		"",	/* SHIFT-function key 18 */
	F39,	SHFT | SPEC | 'i',		"",	/* SHIFT-function key 19 */
	F40,	SHFT | SPEC | 'j',		"",	/* SHIFT-function key 20 */

	/* Cursor keys */
	
	"kr",	SPEC | 'F',		"",	/* right cursor */
	"ku",	SPEC | 'P',		"",	/* up cursor */
	"kl",	SPEC | 'B',		"",	/* left cursor */
	"kd",	SPEC | 'N',		"",	/* down cursor */

	/* Additional editing keys - e.g. IBM extended keyboard */

	F41,	SPEC | '>',		"",	/* End */
	F42,	SPEC | '<',		"",	/* home */
	F43,	SPEC | 'D',		"",	/* delete character */
	F44,	SPEC | 'V',		"",	/* next page */
	F45,	SPEC | 'Z',		"",	/* previous page */
	F46,	SPEC | 'C',		"",	/* insert character */
	
	F47,	CTRL | SPEC | '>',	"",	/* Ctrl-end  */
	F48,	CTRL | SPEC | '<',	"",	/* Ctrl-home */
	F49,	CTRL | SPEC | 'V',	"", /* Ctrl-Page down */
	F50,	CTRL | SPEC | 'Z',	"", /* Ctrl-Page up 	*/

	/* VT200 editing keys */

	"KY",	SPEC | 'Y',		"",	/* Insert here (yank) */
	"KS",	SPEC | 'S',		"",	/* Find (search) */
	"KR",	SPEC | 'R',		"",	/* Remove */
	"KM",	SPEC | 'M',		"",	/* Select (mark) */

	/* Odds & Ends */

	"kA",	CTRL | 'O',		"",	/* insert line */
	"kb",	CTRL | 'H',		"",	/* backspace */
	"kC",	CTRL | 'L',		"",	/* clear screen */
	"kE",	CTRL | 'K',		"",	/* clear to end of line */
	"kF",	CTRL | 'V',		"",	/* scroll down */
	"kL",	CTRL | 'K',		"",	/* delete line */
	"kR",	CTRL | 'Z',		"",	/* scroll down */
	
#else
	"kA",	CTRL | 'O',		"",	/* insert line */
	"kb",	CTRL | 'H',		"",	/* backspace */
	"kC",	CTRL | 'L',		"",	/* clear screen */
	"kD",	SPEC | 'D',		"",	/* delete character */
	"kd",	SPEC | 'N',		"",	/* down cursor */
	"kE",	CTRL | 'K',		"",	/* clear to end of line */
	"kF",	CTRL | 'V',		"",	/* scroll down */
	"kH",	SPEC | '>',		"",	/* home down [END?] key */
	"kh",	SPEC | '<',		"",	/* home */
	"kI",	SPEC | 'C',		"",	/* insert character */
	"kL",	CTRL | 'K',		"",	/* delete line */
	"kl",	SPEC | 'B',		"",	/* left cursor */
	"kN",	SPEC | 'V',		"",	/* next page */
	"kP",	SPEC | 'Z',		"",	/* previous page */
	"kR",	CTRL | 'Z',		"",	/* scroll down */
	"kr",	SPEC | 'F',		"",	/* right cursor */
	"ku",	SPEC | 'P',		""	/* up cursor */

#endif
};

#define	NTBINDS sizeof(ttable)/sizeof(TBIND)

#if LANCASTER

/* VT - specific additions - I've hard-coded these */

static TBIND vttable[] = {
	"",	KPAD | 'a',	  "\033OP",	/* PF 1 */
	"",	KPAD | 'b',	  "\033OQ",	/* PF 2 */
	"",	KPAD | 'c',	  "\033OR",	/* PF 3 */
	"",	KPAD | 'd',	  "\033OS",	/* PF 3 */
	"",	KPAD | '1',	  "\033Oq",	/* Keypad '1' */
	"",	KPAD | '2',	  "\033Or",	/* Keypad '2' */
	"",	KPAD | '3',	  "\033Os",	/* Keypad '3' */
	"",	KPAD | '4',	  "\033Ot",	/* Keypad '4' */
	"",	KPAD | '5',	  "\033Ou",	/* Keypad '5' */
	"",	KPAD | '6',	  "\033Ov",	/* Keypad '6' */
	"",	KPAD | '7',	  "\033Ow",	/* Keypad '7' */
	"",	KPAD | '8',	  "\033Ox",	/* Keypad '8' */
	"",	KPAD | '9',	  "\033Oy",	/* Keypad '9' */
	"",	KPAD | '0',	  "\033Op",	/* Keypad '0' */
	"",	KPAD | '-',	  "\033Om",	/* Keypad '-' */
	"",	KPAD | ',',	  "\033Ol",	/* Keypad ',' */
	"",	KPAD | '.',	  "\033On",	/* Keypad '.' */
	"",	KPAD | 'E',	  "\033OM"	/* Keypad 'Enter' */
};

#define	NVTBINDS sizeof(vttable)/sizeof(TBIND)

static TBIND * pttable[(NTBINDS+NVTBINDS)]; /* Pointers into the non-blank */
					  					  /* vttable & sttable entries */
static int ntbinds;	 		/* Upper index of above */

#endif
#if LANCASTER
extern VOID PASCAL NEAR ttopen();
#else
extern int	ttopen();
#endif
extern int	ttgetc();
extern int	ttputc();
extern int	tgetnum();
extern int	ttflush();
extern int	ttclose();
extern int	tcapkopen();
extern int	tcapkclose();
extern int	tcapgetc();
extern int	tcapmove();
extern int	tcapeeol();
extern int	tcapeeop();
extern int	tcapbeep();
extern int	tcaprev();
extern int	tcapcres();
extern int	tcapopen();
extern int	tcapclose();
extern int	tput();
extern char	*tgoto();
#if	COLOR
extern	int	tcapfcol();
extern	int	tcapbcol();
#endif
#if HARDSCRL
extern void ttscroll();			/* Perform Hardware Scroll */
#endif

#define TCAPSLEN 1024
char tcapbuf[TCAPSLEN];
char *UP, PC, *CM, *CE, *CL, *SO, *SE, *IS, *KS, *KE;

#if LANCASTER

static int vt_keypad=0;			/* Flag if VT100 keypad available */
static char esc_seq_buffer[MAXESC+1];	/* Escape sequence buffer  */
static char * esc_seq_ptr;		/* Escape sequence pointer */

#endif

TERM term = {
	0, 0, 0, 0,	/* these four values are set dynamically at open time */
	MARGIN,
	SCRSIZ,
	NPAUSE,
	tcapopen,
	tcapclose,
	tcapkopen,
	tcapkclose,
	tcapgetc,
	ttputc,
	ttflush,
	tcapmove,
	tcapeeol,
	tcapeeop,
	tcapbeep,
	tcaprev,
	tcapcres
#if	COLOR
	, tcapfcol,
	tcapbcol
#endif
#if HARDSCRL
	, ttscroll
#endif
};

/*	input buffers and pointers	*/

#define	IBUFSIZE	64	/* this must be a power of 2 */

unsigned int in_buf[IBUFSIZE];	/* input character buffer */
int in_next = 0;		/* pos to retrieve next input character */
int in_last = 0;		/* pos to place most recent input character */

in_init()	/* initialize the input buffer */

{
	in_next = in_last = 0;
}

in_check()	/* is the input buffer non-empty? */

{
	if (in_next == in_last)
		return(FALSE);
	else
		return(TRUE);
}

in_put(event)

int event;	/* event to enter into the input buffer */

{
	in_buf[in_last++] = event;
	in_last &= (IBUFSIZE - 1);
}

int in_get()	/* get an event from the input buffer */

{
	register int event;	/* event to return */

	event = in_buf[in_next++];
	in_next &= (IBUFSIZE - 1);
	return(event);
}


/*	Open the terminal
	put it in RA mode
	learn about the screen size
	read TERMCAP strings for function keys
*/

tcapopen()

{
	register int index;		/* general index */
	char *t, *p;
	char tcbuf[1024];
	char *tv_stype;
	char err_str[72];
	char *getenv();
	char *tgetstr();

#if LANCASTER
	int maxfnkey=0;		/* Number of FN keys */
#endif

	if ((tv_stype = getenv("TERM")) == NULL) {
		puts(TEXT182);
/*		     "Environment variable TERM not defined!" */
		meexit(1);
	}

	if ((tgetent(tcbuf, tv_stype)) != 1) {
		sprintf(err_str, TEXT183, tv_stype);
/*				 "Unknown terminal type %s!" */
		puts(err_str);
		meexit(1);
	}

 
	if ((term.t_nrow=(short)tgetnum("li")-1) == -1) {
	       puts(TEXT184);
/*		    "termcap entry incomplete (lines)" */
	       meexit(1);
	}
#if LANCASTER
	term.t_mrow =  256;
#else
	term.t_mrow = term.t_nrow;
#endif

	if ((term.t_ncol=(short)tgetnum("co")) == -1){
		puts(TEXT185);
/*		    "Termcap entry incomplete (columns)" */
		meexit(1);
	}
#if LANCASTER
	term.t_mcol = 256;
#else
	term.t_mcol = term.t_ncol;
#endif

	p = tcapbuf;
	t = tgetstr("pc", &p);
	if (t)
		PC = *t;

	CL = tgetstr("cl", &p);
	CM = tgetstr("cm", &p);
	CE = tgetstr("ce", &p);
	UP = tgetstr("up", &p);
	SE = tgetstr("se", &p);
	SO = tgetstr("so", &p);
	if (SO != NULL)
		revexist = TRUE;

	if (CL == NULL || CM == NULL || UP == NULL)
	{
		puts(TEXT186);
/*		     "Incomplete termcap entry\n" */
		meexit(1);
	}

	if (CE == NULL) 	/* will we be able to use clear to EOL? */
		eolexist = FALSE;
		 
	IS = tgetstr("is", &p); /* extract init string */
	KS = tgetstr("ks", &p); /* extract keypad transmit string */
	KE = tgetstr("ke", &p); /* extract keypad transmit end string */

#if LANCASTER
	ntbinds=0;

	if ( (tcflags=tgetnum(VTCAP)) == -1 )
	{
		/* Not a VT terminal - can't hard scroll */
		term.t_scroll=NULL;
		tcflags = 0;
	}
	else
	{

		/* If terminal has VT100 keypad include the bindings */
		if ( tcflags & TCF_VTKEYS )
			for (ntbinds=0; ntbinds<NVTBINDS; ntbinds++)
				pttable[ntbinds] = &vttable[ntbinds];
	}

	/* read definitions of various function keys into ttable */
	/* placing pointers into the non-null ones into pttable. */
	/* If the sequence is a single character, make sure it is */
	/* not bound to anything */
	
	for (index = 0; index < NTBINDS; index++) {
		t = p;
		strcpy(ttable[index].p_seq,
			fixnull(tgetstr(ttable[index].p_name, &t)));
		if (*ttable[index].p_seq)
		{
			pttable[ntbinds++] = &ttable[index];
			if(index && (index<=20)) maxfnkey++;

			/* If it corresponds to a single key stroke */
			/* ensure it is not bound */
			/*
			if (strlen(ttable[index].p_seq)==1)
				unbindchar(ctoec(*ttable[index].p_seq)); */
		}
	}
	tcflags = (tcflags & ~TCF_NFMASK) | (maxfnkey & TCF_NFMASK);
#else		
	/* read definitions of various function keys into ttable */
	for (index = 0; index < NTBINDS; index++) {
		strcpy(ttable[index].p_seq,
			fixnull(tgetstr(ttable[index].p_name, &p)));
	}
#endif
	/* tell unix we are goint to use the terminal */
	ttopen();

	/* make sure we don't over run the buffer (TOO LATE I THINK) */
	if (p >= &tcapbuf[TCAPSLEN]) {
		puts(TEXT187);
/*		     "Terminal description too big!\n" */
		meexit(1);
	}

	/* send init strings if defined */
	if (IS != NULL)
		putpad(IS);
 
	if (KS != NULL)
		putpad(KS);

	/* initialize the input buffer */
	in_init();
}
 
tcapclose()
{
	/* send end-of-keypad-transmit string if defined */
	if (KE != NULL)
		putpad(KE);
	ttclose();
#if LANCASTER
	/* Reset VT100 keypad */
	if (vt_keypad) putpad("\033>");
#endif
}

tcapkopen()

{
#if LANCASTER
	/* Enable function key sequences */
	*(esc_seq_ptr=esc_seq_buffer)=0;
	fnkeys_disabled = 0;
	/* Enable VT100 application pad */
	if (vt_keypad) putpad("\033=");
#endif
	
	strcpy(sres, "NORMAL");
}

tcapkclose()

{
}

unsigned int extcode(c)

unsigned int c;

{
	return(c);
}

/*	TCAPGETC:	Get on character.  Resolve and setup all the
			appropriate keystroke escapes as defined in
			the comments at the beginning of input.c
*/

int tcapgetc()

{
	int c;		/* current extended keystroke */

	/* if there are already keys waiting.... send them */
	if (in_check())
		return(in_get());

	/* otherwise... get the char for now */
	c = get1key();

	/* unfold the control bit back into the character */
	if ((CTRL & c) && (c & 255) >= '@' )
		c = (c & ~ CTRL) - '@';

	/* fold the event type into the input stream as an escape seq */
	if ((c & ~255) != 0) {
		in_put(0);		/* keyboard escape prefix */
		in_put(c >> 8);		/* event type */
		in_put(c & 255);	/* event code */
		return(tcapgetc());
	}

	return(c);
}

#if	LANCASTER

/*	GET1KEY:	Get one keystroke.
			Lancaster version solves the problem of distinguishing
			function keys returning escape sequences from META
			sequences by checking each character following an
			ESC against the known function keys.  Once a match
			is found, the code is returned.  If no match is found,
			the sequence is returned 'raw' via another typahead
			buffer.
			This will work well with ANSI terminals whose function
			keys begin with either ESC [ or ESC O, but may
			interfere with META sequences on any terminal which
			returns 'ESC' and an ASCII character for it's keys.

			*/

int PASCAL NEAR get1key()
{
	register int c;		/* Character being processesed */
	
	/* Variables for function key identification */
	
	register char *isp,*ksp;    /* Pointers used during matching */
	int partmatch;	    /* Set non-zero if input sequence could */
		   	    /* be part of one or more function key sequence */
	int index;	    /* Index into Termcap sequence list */
	TBIND ** ttab_ptr;  /* Pointer into pttable */
	
	int meta_spec;	    /* Kludge for ESC-FN sequences */

	/* If an unrecognised escape sequence is still in the buffer */
	/* get character from there				     */

	if (*esc_seq_ptr)
		return((c = *esc_seq_ptr++)==ESC ? CTRL | '[' : c);
		
	/* Get 1 character from the keyboard */	
		
	c=ttgetc();
	
	/* If it's not ESC, let it through */
	
	if (c > 31 || c == 0)
		return(c);

	if (fnkeys_disabled)
		return(ctoec(c));
			
	/* Try to identify the incoming escape sequence */

	esc_seq_ptr=esc_seq_buffer;
	*esc_seq_ptr++=c;
	*esc_seq_ptr=0;
	meta_spec=0;
	
	do {
		/* Get next chatacter */
		if( *esc_seq_buffer == ESC && (*esc_seq_ptr++=ttgetc()) == ESC ) 		
		{
			/* Trap for ESC-ESC at start of string */

			if(esc_seq_ptr == &esc_seq_buffer[2])
			{
				/* Drop the second escape */
				esc_seq_ptr--;
				/* Set up meta spec flag */
				meta_spec=META;
			}
		}
		*esc_seq_ptr=0;

		/* Match what we have so far against possible keys */	
		
		partmatch=0;
		for(index=0,ttab_ptr=pttable; index<ntbinds; index++,ttab_ptr++)
		{
			/* if( *(*ttab_ptr)->p_seq ==ESC)
			{ */
				for(
					isp=esc_seq_buffer, ksp=(*ttab_ptr)->p_seq;
					*isp && *ksp && *isp==*ksp;
					ksp++,isp++
				);
			
				if (!*ksp)
					/* A complete match - return code */
					return((*ttab_ptr)->p_code | meta_spec);
				if (!*isp)
					/* Partial match - need more input */
					/* characters */
					partmatch=TRUE;
			/* } */
		}
	} 
	/* Keep going until input sequence cannot match any keys */
	while(partmatch && (esc_seq_ptr != &esc_seq_buffer[MAXESC]));
	
	/* We have an escape sequence not matching any keys. Return first char */
	/* & point esc_seq_ptr to the remainder of the string so it is passed  */
	/* on to tcapgetc */
	
	esc_seq_ptr = (&(esc_seq_buffer[1]));
	return(*esc_seq_buffer == ESC ? CTRL | '[' : *esc_seq_buffer );
}

#else
			
/*	GET1KEY:	Get one keystroke. The only prefixs legal here
			are the SPEC and CTRL prefixes.

	Note:

		Escape sequences that are generated by terminal function
		and cursor keys could be confused with the user typing
		the default META prefix followed by other chars... ie

		UPARROW  =  <ESC>A   on some terminals...
		apropos  =  M-A

		The difference is determined by measuring the time between
		the input of the first and second character... if an <ESC>
		is types, and is not followed by another char in 1/30 of
		a second (think 300 baud) then it is a user input, otherwise
		it was generated by an escape sequence and should be SPECed.
*/

int PASCAL NEAR get1key()

{
	register int c;
	register int index;	/* index into termcap binding table */
	char *sp;
#if	BSD | V7 | HPUX
	int fdset;
	struct timeval timeout;
#endif
	char cseq[10];		/* current sequence being parsed */

	c = ttgetc();

	/* if it is not an escape character */
	if (c != 27)
	        return(c);

	/* process a possible escape sequence */
	/* set up to check the keyboard for input */
#if	BSD | V7 | HPUX
	fdset = 1;
	timeout.tv_sec = 0;
	timeout.tv_usec = 35000L;

	/* check to see if things are pending soon */
	if (kbdmode != PLAY &&
		select(1, &fdset, (int *)NULL, (int *)NULL, &timeout) == 0)
		return(CTRL | '[');
#endif

#if XENIX | SUNOS
	if ((kbdmode != PLAY) && (rdchk(0) <= 0)) {
		nap(35000L);
		if (rdchk(0) <= 0)
			return(CTRL | '[');
	}
#endif

#if	USG
	/* we don't know how to do this check for a pending char within
	   1/30th of a second machine independantly in the general System V
	   case.... so we don't */
	if (kbdmode != PLAY)
		return(CTRL | '[');
#endif

	/* a key is pending within 1/30 of a sec... its an escape sequence */
	cseq[0] = 27;
	sp = &cseq[1];
	while (sp < &cseq[6]) {
		c = ttgetc();
		*sp++ = c;
		*sp = 0;
		for (index = 0; index < NTBINDS; index++) {
			if (strcmp(cseq, ttable[index].p_seq) == 0)
				return(ttable[index].p_code);
		}
	}
	return(SPEC | 0);
}

#endif

tcapmove(row, col)
register int row, col;
{
	putpad(tgoto(CM, col, row));
}

tcapeeol()
{
	putpad(CE);
}

tcapeeop()
{
	putpad(CL);
}

tcaprev(state)		/* change reverse video status */

int state;		/* FALSE = normal video, TRUE = reverse video */

{
/*	static int revstate = FALSE;*/

	if (state) {
		if (SO != NULL)
			putpad(SO);
	} else
		if (SE != NULL)
			putpad(SE);
}

tcapcres()	/* change screen resolution */

{
	return(TRUE);
}

spal(dummy)	/* change palette string */

{
	/*	Does nothing here	*/
}

#if	COLOR
tcapfcol()	/* no colors here, ignore this */
{
}

tcapbcol()	/* no colors here, ignore this */
{
}
#endif

tcapbeep()
{
	ttputc(BEL);
}

void TTpad(n)
int n;
{
	while(n--) ttputc(0);
}

/*******************************************************************************
	ttscroll

	Hardware scroll region of terminal from "top" to "bottom" by "lines"
	If lines is -ve, scroll downwards (i.e. move existing text down)
	otherwise scroll upwards.
*******************************************************************************/

void PASCAL NEAR ttscroll( top, bottom, lines)
int top, bottom, lines;
{
	printf("\033[%d;%dr",top+1,bottom+1);
	TTmove(top,0);
	printf("\033[%d%c",abs(lines),(lines<0) ? 'L' : 'M');
	printf("\033[;r");
	TTmove(ttrow,ttcol);
}

putpad(str)
char	*str;
{
	tputs(str, 1, ttputc);
}

putnpad(str, n)
char	*str;
{
	tputs(str, n, ttputc);
}


#if	FLABEL
fnclabel(f, n)		/* label a function key */

int f,n;	/* default flag, numeric argument [unused] */

{
	/* on machines with no function keys...don't bother */
	return(TRUE);
}
#endif
#else

hello()
{
}

#endif
